# This script lists all assigned devices for all VMs in the system

Set-Location $PSScriptRoot
.("..\AOFLibrary\AOFLibrary.ps1")

$VMs = Get-VM

# Loop through each VM and get assigned devices
foreach ($vm in $VMs) {
    Write-Host "VM Name: $($vm.Name)"
    
    # Get the assigned devices for the current VM
    $assignedDevices = Get-VMAssignableDevice -VMName $vm.Name
    
    if ($assignedDevices) {
        foreach ($device in $assignedDevices) {
            Write-Host "  Device Location Path: $($device.LocationPath)"
            Write-Host "  Device Instance ID: $(Get-GpuInstanceId -GpuLocationPath $device.LocationPath)"
            Write-Host ""
        }
    } else {
        Write-Host "  No devices assigned."
    }
}

Write-Host "Completed listing all assigned devices for all VMs."
